//@author: colorsound
//@tags: Oscillator HLSL
//@credits: gregsn

struct Oscillator
{	
float CurrentPos;
float GoalPos;
float PreviousPos;	
float CurrentVel;
float PreviousVel;	
float DirValue;
float ProcessValue;

};

SamplerState mySampler : IMMUTABLE
{
    Filter = MIN_MAG_MIP_LINEAR;
    AddressU = Clamp;
    AddressV = Clamp;
};


//Make a Texture1D Pin to get the some values and interpolate.
Texture1D ffttex;
float Gain=100;

//Read Write Buffer for Calculation and output to the Display Shaders.
RWStructuredBuffer<Oscillator> Output : BACKBUFFER;

//Texture coordinates Input Buffer
StructuredBuffer<float2> uv;

float InterpolateA = 20;

float energy = 0.3;
float damping = 0.8;
float dT=1;

[numthreads(128, 1, 1)]
void CS_Oscillator( uint3 i : SV_DispatchThreadID)
{ 

//sample the audio values
float fft = ffttex.SampleLevel(mySampler,(uv[i.x].x/InterpolateA),0).r*Gain;//Those are the incoming values.
	
Output[i.x].GoalPos =fft;//Our Input Value Into the Struct
	
float acc = energy * (Output[i.x].GoalPos - Output[i.x].PreviousPos) - (2 * damping  * Output[i.x].PreviousVel);
	
Output[i.x].CurrentVel = Output[i.x].PreviousVel + acc * dT;
	
Output[i.x].CurrentPos = Output[i.x].PreviousPos + (Output[i.x].PreviousVel + 0.5 * acc * dT) * dT;

//AutoFeed for getting FrameDiff	
Output[i.x].PreviousPos = Output[i.x].CurrentPos;
Output[i.x].PreviousVel =  Output[i.x].CurrentVel;	
	
//This is the value we Output and read in the DisplayShader 	
Output[i.x].ProcessValue = Output[i.x].CurrentPos;	
	
}

technique11 TOscillator
{
	pass P0
	{
		SetComputeShader( CompileShader( cs_5_0, CS_Oscillator() ) );
	}
}



